definition module EdText;

import EdTypes;
from EdTextConstants import NewlStr;
     
EmptyText	:== EmptyBlock:!Nil;
EmptyBlock	:== EmptyLine:!Nil;
EmptyLine	:== NewlStr:!Nil;

Text_GetLine :: !Int !Text -> TLine;
Text_GetLines :: !Int !Int !Text -> List TLine;
Text_SetLine :: !Int !TLine !Text -> Text;
Text_InsertLine	:: !Int !TLine !Text -> Text;
Text_RemoveLine	:: !Int !Text -> Text;
Text_CutSelection :: !PartTSel !Text -> (!Clipboard,!Text);
Text_CopySelection :: !PartTSel !Text -> Clipboard;
Text_PasteClipboard	:: !Clipboard !Int !Int !Text -> Text;
Text_ClipboardToText :: !Clipboard -> (!Text, !NrLines);
Text_StringsToText :: !(List String) -> Text;
Text_AppendText	:: !Text !Text -> Text;
Text_AppendNewLine :: !Text -> Text;
Text_NrLines :: !Text -> Int;
Line_LineToString :: !TLine -> String;
Line_MakeLine :: !String -> TLine;
Line_SplitLine :: !Int !TLine -> (!TLine,!TLine);
Line_GlueLine :: !TLine !TLine -> TLine;
Line_GlueAfter :: !TLine !TLine -> TLine;
Line_NrChars :: !TLine -> Int;
LineToBefore :: !TLine !TLine -> TLine;
BeforeToLine :: !TLine -> TLine;
CutFromCurLine :: !PartTSel !CurLine -> (!Clipboard,!TLine,!TLine);
ClipboardToText	:: !Clipboard -> (!Text,!NrLines);
